package com.agilex.healthcare.veteranappointment.validator;

import com.fasterxml.jackson.annotation.JsonFormat;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


@JsonFormat(shape = JsonFormat.Shape.OBJECT)
@XmlRootElement(
    name = "validationErrors",
    namespace = "http://healthcare.agilex.com/mobilehealthplatform"
)
public class ValidationErrors<T> extends ArrayList<ValidationError> implements Serializable {
    private static final long serialVersionUID = -8674522177519030220L;
    private T requestObject;

    public ValidationErrors() {
    }

    public T getRequestObject() {
        return this.requestObject;
    }

    public void setRequestObject(T requestObject) {
        this.requestObject = requestObject;
    }

    @XmlElement(
        namespace = "http://healthcare.agilex.com/mobilehealthplatform"
    )
    public List<ValidationError> getErrors() {
        List<ValidationError> list = new ArrayList<ValidationError>();
        for (ValidationError validationError : this) {
            list.add(validationError);
        }
        return list;
    }

    @XmlElement(
        name = "object-type"
    )
    public String getObjectType() {
        return this.getClass().getSimpleName();
    }

    public void addIfNotNull(ValidationError e) {
        if(e != null) {
            this.add(e);
        }

    }
}